/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  adc.h
//  Functions for using the integrated AD converters
//  The three AD inputs are used for the NTCs (temperature measurement)
//
//  Matthias Ulmann, Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#ifndef ADC_H
#define ADC_H


// bits for analog inputs A0, A1, A2, A6, A7
#define A0_BIT			BIT0
#define A1_BIT			BIT1
#define A2_BIT			BIT2
#define A6_BIT			BIT6
#define A7_BIT			BIT7

// function select register for A0, A1, A2, A6, A7
#define A0_PSEL			P2SEL
#define A1_PSEL			P2SEL
#define A2_PSEL			P2SEL
#define A6_PSEL			P3SEL
#define A7_PSEL			P3SEL

// direction register for A0, A1, A2, A6, A7
#define A0_PDIR			P2DIR
#define A1_PDIR			P2DIR
#define A2_PDIR			P2DIR
#define A6_PDIR			P3DIR
#define A7_PDIR			P3DIR

// output register for A0, A1, A2, A6, A7
#define A0_POUT			P2OUT
#define A1_POUT			P2OUT
#define A2_POUT			P2OUT
#define A6_POUT			P6OUT
#define A7_POUT			P7OUT

// input register for A0, A1, A2, A6, A7
#define A0_PIN			P2IN
#define A1_PIN			P2IN
#define A2_PIN			P2IN
#define A6_PIN			P6IN
#define A7_PIN			P7IN

// pullup/-down resistor register for A0, A1, A2, A6, A7
#define A0_RES			P2REN
#define A1_RES			P2REN
#define A2_RES			P2REN
#define A6_RES			P3REN
#define A7_RES			P3REN

// definitions for analog inputs
#define NTC_HBRIDGE		A0_BIT
#define NTC_BOARD		A1_BIT
#define NTC_PFC			A2_BIT
#define VOLTAGE_OUT		A6_BIT
#define CURRENT_OUT		A7_BIT


// global variables to store the temperatures in degrees
extern volatile unsigned int temp_pfc, temp_hbridge, temp_chassis;

// global variables to store the the voltage and current of the output
extern volatile unsigned int voltage_output, current_output;

// initialization of the analog inputs
// temperature measurements with NTCs, output voltage and current
extern void init_adc(void);

// Conversion of the sampled digital value into degrees
// The minimum value is 10 degree. For a temperature below a
// value of 0 is returned.
// The maximum value is 99 degree. For a temperature above a
// value of 200 is returned.
extern unsigned int lsb_to_temperature_adc(unsigned int lsb);

// Conversion of the sampled digital value into voltage
// The value has three digits, the last represents hundred millivolts.
// (135 means 13.5V)
extern unsigned int lsb_to_voltage_adc(unsigned int lsb);

// Conversion of the sampled digital value into current
// The value has three digits, the last represents hundred milliamps.
// (135 means 13.5V)
unsigned int lsb_to_current_adc(unsigned int lsb);

// Run the AD converter and calculate the temperature of the 3 NTCs
extern void get_analog_inputs(void);



#endif /*ADC_H*/
